<!DOCTYPE html>
<html>
<head>
    <title>Search Chart</title>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script type="text/javascript">
        google.charts.load('current', {'packages':['corechart', 'bar']});
    </script>
</head>
<body>
    <h1>Live Statistical Data Based on App users' Searches and Queries</h1>
    <form method="POST" action="">
        <label for="search_category">Search Category:</label>
        <select id="search_category" name="search_category">
            <?php
            include "dbconnect.php";
            include "includes/configuration.php";
            $sql = "SELECT DISTINCT search_category FROM searches ORDER BY search_category";
            $result = mysqli_query($conn, $sql);
            while ($row = mysqli_fetch_array($result)) {
                echo "<option value='".$row['search_category']."'>".$row['search_category']."</option>";
            }
            ?>
        </select>
        <label for="start_date">Start Date:</label>
        <input type="date" id="start_date" name="start_date">
        
        <label for="end_date">End Date:</label>
        <input type="date" id="end_date" name="end_date">
        
        <input type="submit" name="submit1" value="Filter">
    </form>
    
    <center><div id="chart_div" style="border-width:20;border-color:orange;border-style:ridge;"></div></center>

    <?php
    if (isset($_POST['submit1'])) {
        // Get filter values from the form
        $searchCategory = isset($_POST['search_category']) ? $_POST['search_category'] : 'Site Category';
        $startDate = isset($_POST['start_date']) ? $_POST['start_date'] : '';
        $endDate = isset($_POST['end_date']) ? $_POST['end_date'] : '';

        // Check if the connection was successful
        if ($conn->connect_error) {
            die(json_encode([
                'status' => 'error',
                'message' => 'Database connection failed: ' . $conn->connect_error
            ]));
        }

        // Fetch data from the database
        $sql = "
            SELECT
                search_title,
                COUNT(search_title) AS count
            FROM
                searches
            WHERE
                search_category = '$searchCategory'";

        if (!empty($startDate) && !empty($endDate)) {
            $sql .= " AND search_date BETWEEN '$startDate' AND '$endDate'";
        }

        $sql .= " GROUP BY search_title ORDER BY count DESC";
        $result = $conn->query($sql);

        $data = [];
        $data[] = ['Search Title', 'Count'];

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = [$row['search_title'], (int)$row['count']];
            }
        } else {
            echo json_encode(["error" => "No data found"]);
            exit;
        }

        $conn->close();

        $jsonData = json_encode($data);
        ?>
        
        <script type="text/javascript">
            google.charts.setOnLoadCallback(drawChart);

            function drawChart() {
                var jsonData = <?php echo $jsonData; ?>;
                var data = google.visualization.arrayToDataTable(jsonData);

                var options = {
                    title: 'Popular Searches Based on:<?php echo $searchCategory;?>',
                    width: 1000,
                    height: 500,
                    chartArea: {width: '80%'},
                    hAxis: {
                        title: 'Tourism Site: <?php echo $searchCategory;?>',
                        minValue: 0
                    },
                    vAxis: {
                        title: 'Search Count'
                    },
                    legend: { position: 'top', maxLines: 3 },
                    bar: { groupWidth: '55%' },
                    isStacked: true,
                    colors: ['teal', '#ff9900', '#109618', '#990099'],
                    backgroundColor: '#f1f8e9',
                    animation: {
                        startup: true,
                        duration: 1000,
                        easing: 'out'
                    }
                };

                var chart = new google.visualization.ColumnChart(document.getElementById('chart_div'));
                chart.draw(data, options);
            }
        </script>
        
        <?php
    }
    ?>
</body>
</html>
