<!DOCTYPE html>
<html>
<head>
    <title>Tourist Guides for Tourism Sites</title>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script type="text/javascript">
        google.charts.load('current', {'packages':['corechart', 'bar']});
    </script>
</head>
<body>
    <?php
    include "dbconnect.php";
    include "includes/configuration.php";

    // Check if the connection was successful
    if ($conn->connect_error) {
        die(json_encode([
            'status' => 'error',
            'message' => 'Database connection failed: ' . $conn->connect_error
        ]));
    }

    // Fetch data from the database
    $sql = "SELECT site_title, COUNT(site_title) as count FROM guide_sites GROUP BY site_title";
    $result = mysqli_query($conn, $sql);

    $data = [];
    $data[] = ['Site Title', 'Count'];  // Add headers for the data

    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = [$row['site_title'], (int)$row['count']];
        }
    } else {
        echo json_encode(["error" => "No data found"]);
        exit;
    }

    $conn->close();

    $jsonData = json_encode($data);
    ?>

    <h1>Registered Tourist Guides for Tourist Sites</h1>
    
    <center>
        <div 
        id="chart_div" 
        style="border-width:2;border-color:orange;border-style:ridge;min-height:500px;">
            
        </div>
    </center>

    <script type="text/javascript">
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
            var jsonData = <?php echo $jsonData; ?>;
            var data = google.visualization.arrayToDataTable(jsonData);

            var options = {
                title: 'Number of  Guides per Tourist Sites',
                width: 1000,
                height: 500,
                chartArea: {width: '80%'},
                hAxis: {
                    title: 'Tourism Sites',
                    minValue: 0
                },
                vAxis: {
                    title: 'Tourist Guides Count'
                },
                legend: { position: 'top', maxLines: 3 },
                bar: { groupWidth: '55%' },
                isStacked: true,
                colors: ['teal', '#ff9900', '#109618', '#990099'],
                backgroundColor: '#f1f8e9',
                animation: {
                    startup: true,
                    duration: 1000,
                    easing: 'out'
                }
            };

            var chart = new google.visualization.ColumnChart(document.getElementById('chart_div'));
            chart.draw(data, options);
        }
    </script>
</body>
</html>
